#!/bin/bash

# Let's read in our commandline arguments
VCODEC="$1"
shift;

ACODEC="$1"
shift;

VB="$1"
shift;

AB="$1"
shift;

SIZE="$1"
shift;

FPS="$1"
shift;

PROTOCOL="$1"
shift;

HTTP_USER="$1"
shift;

HTTP_PWD="$1"
shift;

# See if an older VLC session is alive
pids=`pidof vlc`
if [ -n "$pids" ]; then
   echo "VLC already alive, I'm going to whack it. THE PROCESS I MEAN!";
   touch /var/tmp/STREAMSTOP
   kill $pids
   sleep 1s;
fi 

if [ -n "$1" ];then
   while [ -n "$1" ]; do
      echo "Starting Stream of $1"
      
      if [ $PROTOCOL = "mms" ]; then 
        #**VLC_PATH**# -I http --http-host=:#**STREAM_ADMIN**#  --sout-transcode-fps=$FPS --sout-transcode-deinterlace $1 ":sout=#transcode{vcodec=$VCODEC,acodec=$ACODEC,vb=$VB,ab=$AB,scale=$SIZE}:std{access=mmsh,mux=asfh,url=:#**STREAM_PORT**#}"
      elif [ $PROTOCOL = "http" ]; then
        #**VLC_PATH**# -I http --http-host=:#**STREAM_ADMIN**#  --sout-transcode-fps=$FPS --sout-transcode-deinterlace $1 ":sout=#transcode{vcodec=$VCODEC,acodec=$ACODEC,vb=$VB,ab=$AB,scale=$SIZE}:std{access=http{user=$HTTP_USER,pwd=$HTTP_PWD,mime=video/x-ms-asf},mux=asf,url=:#**STREAM_PORT**#}"
      fi

      if [ -f /var/tmp/STREAMSTOP ]; then
         rm -f /var/tmp/STREAMSTOP
	 break;
      fi
      shift;
   done
else
   echo "Please select a show to stream."
fi
