#!/bin/bash
#
# MythStreamTV Install Script

#
# InstallFile(): Copies the file and replaces variables
InstallFile() {
   SOURCE_FILE="$1"
   DEST_FILE="$2"

   echo -n ".... Installing $DEST_FILE: "
   cat $SOURCE_FILE                                             | \
         sed -e "s|#\*\*NEW_STREAM_DIR\*\*#|$NEW_STREAM_DIR|g"  | \
         sed -e "s|#\*\*STREAM_ADDR\*\*#|$STREAM_ADDR|g"        | \
         sed -e "s|#\*\*STREAM_ADMIN\*\*#|$STREAM_ADMIN|g"	| \
	 sed -e "s|#\*\*STREAM_PORT\*\*#|$STREAM_PORT|g"        | \
	 sed -e "s|#\*\*VLC_PATH\*\*#|$VLC_PATH|g"              > $DEST_FILE
   RET=$?
   if [ $RET -gt 0 ]; then
      echo Failed
      exit 1
   else
      echo Success
   fi
}

RunAndTest() {
   $*
   RET=$?
   if [ $RET -gt 0 ]; then
      echo Failed
      exit 1
   fi
}

GetString() {
   echo -n "$1? [$2] "
   read
   if [ -n "$REPLY" ]; then
      READ_STRING="$REPLY"
   else
      READ_STRING="$2"
   fi
}

GetYN() {
   GetString "$1" "$2"
   case $READ_STRING in
      y | Y | yes | YES)
         return 1
	 ;;
   esac

   return 0;
}

InstallToMythWeb() {
   echo -n "........ Fixing up includes/init.php: "
   OUT=`cat $HTTP_DIR/includes/init.php | \
                                           grep -n "'movietimes'  => null,"`
   RET=$?
   if [ $RET -gt 0 ]; then
      echo "Internal error (grep)"
      exit 1
   fi
#   let num="`echo $OUT | cut -d ':' -f 1`"
#   let end="(`echo $OUT | cut -d ':' -f 1`) - 1"
#   cat $HTTP_DIR/themes/Default/theme.php | head -$end \
#                                      > $HTTP_DIR/themes/Default/theme.php.new
#   RET=$?
#   if [ $RET -gt 0 ]; then
#      echo Failed
#      exit 1
#   fi
#   cat << EOF >> $HTTP_DIR/themes/Default/theme.php.new
#                <a href="mythstreamtv.php"><?php echo t('Stream Recordings') ?></a>
#                &nbsp; | &nbsp;
#EOF
#   cat $HTTP_DIR/themes/Default/theme.php | tail +$num \
#                                      >> $HTTP_DIR/themes/Default/theme.php.new
#   RET=$?
#   if [ $RET -gt 0 ]; then
#      echo Failed
#      exit 1
#   fi
#   RunAndTest cp -f $HTTP_DIR/themes/Default/theme.php.new \
#                    $HTTP_DIR/themes/Default/theme.php
#   rm -f $HTTP_DI/R/themes/Default/theme.php.new
#   echo Done
#
#   echo -n "........ Fixing up languages/English.php: "
#   OUT=`cat $HTTP_DIR/languages/English.php | grep -n "Recorded Programs"`
#   RET=$?
#   if [ $RET -gt 0 ]; then
#      echo "Internal error (grep)"
#      exit 1
#   fi
#   let num="`echo $OUT | cut -d ':' -f 1`"
#   let begin="$num - 1"
#   cat $HTTP_DIR/languages/English.php | head -$begin \
#                                      > $HTTP_DIR/languages/English.php.new
#   RET=$?
#   if [ $RET -gt 0 ]; then
#      echo Failed
#      exit 1
#   fi
#   cat << EOF >> $HTTP_DIR/languages/English.php.new
#    'Stream Recordings'         => '',
#EOF
#   cat $HTTP_DIR/languages/English.php | tail +$num \
#                                      >> $HTTP_DIR/languages/English.php.new
#   RET=$?
#   if [ $RET -gt 0 ]; then
#      echo Failed
#      exit 1
#   fi
#   RunAndTest cp -f $HTTP_DIR/languages/English.php.new \
#                    $HTTP_DIR/languages/English.php
#   rm -f $HTTP_DIR/languages/English.php.new
   echo Done
}

echo "Setting up MythStreamTV......"

# Set our defaults
STREAM_DIR=`pwd`
NEW_STREAM_DIR=/usr/share/mythstreamtv
HTTP_DIR=/var/www/mythweb
STREAM_ADDR="ebel.host.com"
STREAM_PORT=8001
STREAM_ADMIN=8002
USER_GROUP="mythtv:mythtv"
VLC_PATH=`which vlc`

# Ask for configuration
let not_ok=1
while [ $not_ok -gt 0 ]; do
   echo
   GetString "MythStreamTV Directory" "$NEW_STREAM_DIR"
   NEW_STREAM_DIR="$READ_STRING"

   GetString "MythWeb HTTP Directory" "$HTTP_DIR"
   HTTP_DIR="$READ_STRING"
   
   GetString "MythStreamTV Server Address" "$STREAM_ADDR"
   STREAM_ADDR="$READ_STRING"
   
   GetString "MythStreamTV Server Port" "$STREAM_PORT"
   STREAM_PORT="$READ_STRING"
   
   GetString "MythStreamTV Stream Admin Port" "$STREAM_ADMIN"
   STREAM_ADMIN="$READ_STRING"

   GetString "MythStreamTV User:Group" "$USER_GROUP"
   USER_GROUP="$READ_STRING"

   GetString "Path to where vlc is installed" "$VLC_PATH"
   VLC_PATH="$READ_STRING"
  
   echo
   echo "Please confirm your configuration:"
   echo "----------------------------------------------------------------------"
   echo "    MythStreamTV Directory         : $NEW_STREAM_DIR"
   echo "    MythWeb HTTP Directory         : $HTTP_DIR"
   echo "    MythStreamTV Server Address    : $STREAM_ADDR"
   echo "    MythStreamTV Server Port       : $STREAM_PORT"
   echo "    MythStreamTV Stream Admin Port : $STREAM_ADMIN"
   echo "    MythStreamTV User:Group        : $USER_GROUP"
   echo "    Path to where vlc is installed : $VLC_PATH"
   echo "----------------------------------------------------------------------"
   GetYN "Is this correct" "n"
   RET=$?
   if [ $RET -eq 1 ]; then
      not_ok=0
   fi
done

echo
echo "Installing MythStreamTV........."
   
# Create our destination directory if needed
if [ ! -d $NEW_STREAM_DIR ]; then
   echo -n ".... Creating target dir $NEW_STREAM_DIR: "
   RunAndTest mkdir $NEW_STREAM_DIR
   echo Done
fi

echo -n ".... Checking MythWeb Compatablity: "
# Let's see if it is the new or old one

InstallFile $STREAM_DIR/mythstreamtv.sh \
            $NEW_STREAM_DIR/mythstreamtv.sh

InstallFile $STREAM_DIR/mythstreamtvactive.sh \
            $NEW_STREAM_DIR/mythstreamtvactive.sh

InstallFile $STREAM_DIR/mythstreamtvctrl.sh \
            $NEW_STREAM_DIR/mythstreamtvctrl.sh

InstallFile $STREAM_DIR/mythstreamtvstop.sh \
            $NEW_STREAM_DIR/mythstreamtvstop.sh

echo "Creating StreamTV Diretory's in MythWEB..."
mkdir $HTTP_DIR/modules/streamtv
mkdir $HTTP_DIR/themes/default/streamtv

InstallFile $STREAM_DIR/modules/handler.php \
            $HTTP_DIR/modules/streamtv/handler.php

InstallFile $STREAM_DIR/modules/init.php \
            $HTTP_DIR/modules/streamtv/init.php

InstallFile $STREAM_DIR/modules/confirm.php \
            $HTTP_DIR/modules/streamtv/confirm.php

InstallFile $STREAM_DIR/modules/createfile.php \
            $HTTP_DIR/modules/streamtv/createfile.php

InstallFile $STREAM_DIR/modules/selectstream.php \
            $HTTP_DIR/modules/streamtv/selectstream.php

InstallFile $STREAM_DIR/themes/createfile.php \
            $HTTP_DIR/themes/default/streamtv/createfile.php

InstallFile $STREAM_DIR/themes/menu.php \
            $HTTP_DIR/themes/default/streamtv/menu.php

InstallFile $STREAM_DIR/themes/confirm.php \
            $HTTP_DIR/themes/default/streamtv/confirm.php

InstallFile $STREAM_DIR/themes/selectstream.php \
            $HTTP_DIR/themes/default/streamtv/selectstream.php

InstallFile $STREAM_DIR/themes/welcome.php \
            $HTTP_DIR/themes/default/streamtv/welcome.php

echo -n ".... Checking MythWeb Installation: "
cat $HTTP_DIR/includes/init.php | grep "'streamtv'" > /dev/null
RET=$?
if [ $RET -gt 0 ]; then
   echo "Required - Installing..."
      InstallToMythWeb
else
   echo "Not required, skipping"
fi

echo -n ".... Fixing up file permissions: "
RunAndTest chown -R $USER_GROUP $NEW_STREAM_DIR
RunAndTest chmod -R a+w $NEW_STREAM_DIR
RunAndTest chmod a+x $NEW_STREAM_DIR/*.sh
RunAndTest chown -R root:root $HTTP_DIR/modules/streamtv
RunAndTest chown -R root:root $HTTP_DIR/themes/default/streamtv
RunAndTest chown -R root:root $HTTP_DIR/modules/streamtv/*.php
RunAndTest chown -R root:root $HTTP_DIR/themes/default/streamtv/*.php
echo Done

echo
echo "Installation Complete!  Good Luck."
